<?php
    get_header();
?>

<div id="banner-area">
	<img src="<?php echo get_template_directory_uri() ?>/assets/images/banner.jpg" alt="" />
	<div class="parallax-overlay"></div>
	<!-- Subpage title start -->
	<div class="banner-title-content">
		<div class="text-center">
			<h2><?php echo single_cat_title("",true);?></h2>
			<nav aria-label="breadcrumb">
				<ol class="breadcrumb justify-content-center">
                    <?php 
                        if (function_exists('dimox_breadcrumbs')) dimox_breadcrumbs(); 
                    ?>
				</ol>
			</nav>
		</div>
	</div><!-- Subpage title end -->
</div><!-- Banner area end -->

<!-- Portfolio start -->
<section id="main-container" class="portfolio-static">
	<div class="container">
		<div class="row">
            <?php 
                $term = get_queried_object();
                $children = category_has_children($term->term_id,'category');
                if($children != null):
                    foreach($children as $child):
            ?>

                <div class="col-sm-3 portfolio-static-item text-center product">
                    <div class="grid">
                        <figure class="m-0 effect-oscar">
                            <img src="<?php if (function_exists('z_taxonomy_image_url')) echo z_taxonomy_image_url($child->term_id); ?>" alt="">
                            <figcaption>
                                <a class="link icon-pentagon" href="<?php echo get_category_link($child->term_id);?>"><i class="fa fa-link"></i></a>
                            </figcaption>
                        </figure>
                        <div class="portfolio-static-desc">
                            <h3><a href="<?php echo get_category_link($child->term_id);?>"><?php echo $child->name;?></a></h3>
                        </div>
                    </div>
                    <!--/ grid end -->
                </div>
                <!--/ item end -->

            <?php 
                endforeach;
                else:
            ?>


        <?php 
            while(have_posts()):
                the_post();
        ?>
			<div class="col-sm-3 portfolio-static-item text-center">
				<div class="grid">
					<figure class="m-0 effect-oscar">
						<img src="<?php the_post_thumbnail_url("full");?>" alt="">
						<figcaption>
							<a class="view icon-pentagon" data-rel="prettyPhoto" href="<?php the_post_thumbnail_url("full");?>"><i
									class="fa fa-search"></i></a>
						</figcaption>
					</figure>
					<div class="portfolio-static-desc">
						<h3><?php the_title();?></h3>
					</div>
				</div>
				<!--/ grid end -->
			</div>
            <!--/ item end -->

            <?php 
                endwhile;
            endif;
                wp_reset_query();
            ?>  
            
		</div><!-- Content row end -->
	</div><!-- Container end -->
</section><!-- Portfolio end -->


<?php
get_footer();