<?php

define('brandland','brandland');




add_action('after_setup_theme', 'my_theme_setup');
function my_theme_setup(){
    load_theme_textdomain(brandland, get_template_directory() . '/languages');
}



function filter_by_country( $where ,$query ) {
	global $wpdb;
	if(is_admin()) return $where;
	
	
	$ok = false;
	if(in_array($query->get('post_type'),array('center','course','member','activity')))
	{
		$ok=true;
	}
	
	if($query->get('coursetype'))
	{
		$ok = true;
	}
	
	if($query->get('membertype'))
	{
		$ok = true;
	}

	if($query->get('centertype'))
	{
		$ok = true;
	}
	
	if(!$ok) return $where;
	
	@session_start();
	
	
	
	if(isset($_SESSION['country']) && $_SESSION['country'])
	{
		
		$country = esc_sql($_SESSION['country']);
		
		$where .= " and {$wpdb->prefix}posts.ID in (

select object_id from {$wpdb->prefix}term_taxonomy tx
inner join {$wpdb->prefix}terms t on t.term_id = tx.term_id  and t.slug='{$country}'
inner join {$wpdb->prefix}term_relationships trr on trr.term_taxonomy_id = tx.term_taxonomy_id

)";	
	}

	return $where;
    
}
add_filter( 'posts_where' , 'filter_by_country',10,2 );

function my_init() {
	
	
	register_nav_menu('header-menu', __('Header Menu'));
	register_nav_menu('left-menu', __('Left menu'));
	register_nav_menu('right-menu', __('Right menu'));
	register_nav_menu('main', __('main'));

	add_theme_support('post-thumbnails');

	set_post_thumbnail_size(150, 150);

	add_image_size('wide', 1140, 400, true);
	
	checkAjax();
	
}

add_action('init', 'my_init');

function new_excerpt_more($more) {
	return '&nbsp;&nbsp;<a class="more-link" href="' . get_permalink() . '">read more...</a>';
}

add_filter('excerpt_more', 'new_excerpt_more');

/**
 * Register Sidebar
 */
function brandland_register_sidebars() {

    /* Register the primary sidebar. */
    register_sidebar(array(
        'id' => 'main-sidebar',
        'name' => 'Main Sidebar',
    ));
	
	 register_sidebar(array(
        'id' => 'about-us',
        'name' => 'About us',
    ));

	 register_sidebar(array(
        'id' => 'contact-us',
        'name' => 'Contact us',
    ));
    
 register_sidebar(array(
        'id' => 'rate',
        'name' => 'Rate',
    ));

	 register_sidebar(array(
        'id' => 'footer-left',
        'name' => ' Footer Left',
    ));

	 register_sidebar(array(
        'id' => 'footer-center',
        'name' => ' Footer Center',
    ));
	
	 register_sidebar(array(
        'id' => 'footer-right',
        'name' => ' Footer Right',
    ));
	 register_sidebar(array(
        'id' => 'footer-bottom',
        'name' => ' Footer Bottom',
    ));
	register_sidebar(array(
        'id' => 'vision',
        'name' => 'Vision',
    ));
	register_sidebar(array(
        'id' => 'mission',
        'name' => 'Mission',
    ));
	/* Repeat register_sidebar() code for additional sidebars. */
}

add_action('widgets_init', 'brandland_register_sidebars');

add_action('about-us', 'About us');

add_action('contact-us', 'About us');

/**
 * Provides a standard format for the page title depending on the view. This is
 * filtered so that plugins can provide alternative title formats.
 *
 * @param       string    $title    Default title text for current view.
 * @param       string    $sep      Optional separator.
 * @return      string              The filtered title.
 * @package     mayer
 * @subpackage  includes
 * @version     1.0.0
 * @since       1.0.0
 */
function mayer_wp_title($title, $sep) {
	global $paged, $page;

	if (is_feed()) {
		return $title;
	}// end if

	// Add the site name.
	$title .= get_bloginfo('name');

	// Add the site description for the home/front page.
	$site_description = get_bloginfo('description', 'display');
	if ($site_description && (is_home() || is_front_page())) {
		$title = "$title $sep $site_description";
	}// end if

	// Add a page number if necessary.
	if ($paged >= 2 || $page >= 2) {
		$title = sprintf(__('Page %s', 'mayer'), max($paged, $page)) . " $sep $title";
	}// end if

	return $title;

}// end mayer_wp_title

add_filter('wp_title', 'mayer_wp_title', 10, 2);

//Page Slug Body Class
function add_slug_body_class($classes) {
	global $post;
	if (isset($post)) {
		$classes[] = $post->post_type . '-' . $post->post_name;
	}
	return $classes;
}


register_nav_menus( array(
    'primary' => __( 'Primary Menu', 'main' ),
) );


require_once('wp-bootstrap-navwalker.php');
add_filter('wp_title', 'mayer_wp_title', 10, 2);
add_filter( 'get_the_archive_title', 'paulg_5_get_the_archive_title' );
 
function paulg_5_get_the_archive_title( $title ) {
	
    $prefixes_to_remove = array(
        'Year: ',
        'Archive: ',
        'Category: ',
        'protfolio-cat: ',
        'coursetype: ',
        'centertype: ',
        'membertype:',
        'Archives: ',
        'booktype:',
        'الآرشيفات:'
                // Add other prefixes you want to remove...
    );
 
    foreach( $prefixes_to_remove as $prefix ) {
        // If title starts with $prefix, remove it and finish
        if( $prefix == substr( $title, 0, strlen( $prefix ) ) )  {
            return substr( $title, strlen( $prefix ) );
        }
    }
 
    // No prefix was matched
    return $title;
}


function checkAjax()
{
	
	if(isset($_GET['getrandomads']))
	{
		get_template_part('sliderrandomads');
		die();
	}
	
	if(isset($_GET['topads']))
	{
		get_template_part('topads');
		die();
	}
	
	if(isset($_GET['getrandomads']))
	{
		get_template_part('sliderrandomads');
		die();
	}
	
	
	if(isset($_GET['getactivecourses']))
	{
		get_template_part('activecourses');
		die();
	}
	
		
}

if(isset($_POST['formpost'])){
	ini_set('precision', 16);

	if(isset($_POST["sub"]))
	{
		$tube20			= 0.025 * $_POST['tube20'] ;
		$tube40			= 0.050 * $_POST['tube40'] ;
		$light60 		= 0.075 * $_POST['light60'] ;
		$light100 		= 0.125 * $_POST['light100'] ;
		$energy 		= 0.025 * $_POST['energy'] ;
		$ton1 			= 2.750 * $_POST['1ton'] ;
		$ton15 			= 4.125 * $_POST['15ton'] ;
		$ton2  			= 6.000 * $_POST['2ton'] ;
		$ton25 			= 8.125 * $_POST['25ton'] ;
		$ton3 			= 8.750 * $_POST['3ton'] ;
		$ton4  			= 11.000 * $_POST['4ton'] ;
		$ton5 			= 12.500 * $_POST['5ton'] ;
		$fans 			= 0.175 * $_POST['fans'] ;
		$air 			= 0.625 * $_POST['air'] ;
		$lcd 			= 0.313 * $_POST['lcd'] ;
		$dvd 			= 0.125 * $_POST['dvd'] ;
		$theater		= 0.500 * $_POST['theater'] ;
		$pc 			= 0.500 * $_POST['pc'] ;
		$laptop 		= 0.313 * $_POST['laptop'] ;
		$refrigerator	= 0.500 * $_POST['refrigerator'] ;
		$freezer		= 0.500 * $_POST['freezer'] ;
		$oven 			= 1.000 * $_POST['oven'] ;
		$washing 		= 0.500 * $_POST['washing'] ;
		$iron 			= 1.250 * $_POST['iron'];
		$heater 		= 1.500 * $_POST['heater'] ;
		$donkey 		= 2.500 * $_POST['donkey'];

		$total = $fans + $tube20 + $tube40 + $light60 + $light100 + $energy + $ton1 + $ton15 + $ton2 + $ton25 + $ton3 + $ton4 + $ton5 + $air + $lcd + $dvd + $theater + $pc + $laptop + $refrigerator + $freezer + $oven + $washing + $iron + $heater + $donkey;
		$totalinwatt = $total * 800;
	}
}

function prefix_nav_description( $item_output, $item, $depth, $args ) {
    if ( !empty( $item->description ) ) {
        $item_output = str_replace( $args->link_after . '</a>', '<a data-description="' . $item->description . '"</a>' . $args->link_after . '</a>', $item_output );
    }
 
    return $item_output;
}
add_filter( 'walker_nav_menu_start_el', 'prefix_nav_description', 10, 4 );

add_filter( 'template_include', 'var_template_include', 1000 );
function var_template_include( $t ){
  $GLOBALS['current_theme_template'] = basename($t);
  return $t;
}
function get_current_template( $echo = false ) {
  if( !isset( $GLOBALS['current_theme_template'] ) ) return false;
  if( $echo ) echo $GLOBALS['current_theme_template']; else  return $GLOBALS['current_theme_template'];
}

/* Flush rewrite rules for custom post types. */
add_action( 'after_switch_theme', 'bt_flush_rewrite_rules' );

/* Flush your rewrite rules */
function bt_flush_rewrite_rules() {
     flush_rewrite_rules();
}

add_filter('wpcf7_form_elements', function($content) {
    $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);

    return $content;
});



add_post_type_support( 'page', 'excerpt' );



function category_has_children( $term_id, $taxonomy) {
    $children = get_categories( array( 
        'parent'      => $term_id,
		'taxonomy'      => $taxonomy,
        'hide_empty'    => false,
    ) );
    return ( $children );
}


// Breadcrum

function dimox_breadcrumbs() {
  
	$delimiter = '&raquo;';
	$name = __('Home',brandland); //text for the 'Home' link
	$currentBefore = '<li class=" text-white current">';
	$currentAfter = '</li>';
	
	if ( !is_home() && !is_front_page() || is_paged() ) {
	  
	  global $post;
	  $home = get_bloginfo('url');
	  echo '<li class=""><a href="' . $home . '">' . $name . '</a></li> ' . $delimiter . ' ';
	
	  if ( is_category() ) {
		global $wp_query;
		$cat_obj = $wp_query->get_queried_object();
		$thisCat = $cat_obj->term_id;
		$thisCat = get_category($thisCat);
		$parentCat = get_category($thisCat->parent);
		if ($thisCat->parent != 0) echo(get_category_parents($parentCat, TRUE, ' ' . $delimiter . ' '));
		echo $currentBefore . '';
		single_cat_title();
		echo '' . $currentAfter;
	
	  } elseif ( is_day() ) {
		echo '<li class=""><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
		echo '<li class=""><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a></li> ' . $delimiter . ' ';
		echo $currentBefore . get_the_time('d') . $currentAfter;
	
	  } elseif ( is_month() ) {
		echo '<li class=""><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li> ' . $delimiter . ' ';
		echo $currentBefore . get_the_time('F') . $currentAfter;
	
	  } elseif ( is_year() ) {
		echo $currentBefore . get_the_time('Y') . $currentAfter;
	
	  } elseif ( is_single() && !is_attachment() ) {
		$cat = get_the_category(); $cat = $cat[0];
		echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
		echo $currentBefore;
		the_title();
		echo $currentAfter;
	
	  } elseif ( is_attachment() ) {
		$parent = get_post($post->post_parent);
		$cat = get_the_category($parent->ID); $cat = $cat[0];
		echo get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
		echo '<li class=""><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li> ' . $delimiter . ' ';
		echo $currentBefore;
		the_title();
		echo $currentAfter;
	
	  } elseif ( is_page() && !$post->post_parent ) {
		echo $currentBefore;
		the_title();
		echo $currentAfter;
	
	  } elseif ( is_page() && $post->post_parent ) {
		$parent_id  = $post->post_parent;
		$breadcrumbs = array();
		while ($parent_id) {
		  $page = get_page($parent_id);
		  $breadcrumbs[] = '<li class=""><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
		  $parent_id  = $page->post_parent;
		}
		$breadcrumbs = array_reverse($breadcrumbs);
		foreach ($breadcrumbs as $crumb) echo $crumb . ' ' . $delimiter . ' ';
		echo $currentBefore;
		the_title();
		echo $currentAfter;
	
	  } elseif ( is_search() ) {
		echo $currentBefore . 'Search results for &#39;' . get_search_query() . '&#39;' . $currentAfter;
	
	  } elseif ( is_tag() ) {
		echo $currentBefore . 'Posts tagged &#39;';
		single_tag_title();
		echo '&#39;' . $currentAfter;
	
	  } elseif ( is_author() ) {
		 global $author;
		$userdata = get_userdata($author);
		echo $currentBefore . 'Articles posted by ' . $userdata->display_name . $currentAfter;
	
	  } elseif ( is_404() ) {
		echo $currentBefore . 'Error 404' . $currentAfter;
	  }
	
	  if ( get_query_var('paged') ) {
		if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
		echo __('Page') . ' ' . get_query_var('paged');
		if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
	  }
	
	
	}
  }
  